﻿var _rowId;
var _orderNo;
var _itemNo;

$(function () {

    //Internal Message Center Buttons
    //On Order Dashboard page get the query string values, on message center page get the values that were stored in data-# attribute (for orderNo and ItemNo)
    $('#btnApproveConditionalAcceptance').click(function () {
        var orderNo = isNullOrWhiteSpace(getQueryValueByName("on")) ? $(this).data('orderno') : getQueryValueByName("on");
        var itemNo = isNullOrWhiteSpace(getQueryValueByName("it")) ? $(this).data('itemno') : getQueryValueByName("it");
        AcceptOrderCounterOffer(orderNo, itemNo)
    });

    $('#btnDenyConditionalAcceptance').click(function () {
        var orderNo = isNullOrWhiteSpace(getQueryValueByName("on")) ? $(this).data('orderno') : getQueryValueByName("on");
        var itemNo = isNullOrWhiteSpace(getQueryValueByName("it")) ? $(this).data('itemno') : getQueryValueByName("it");
        confirmDenyCounterOffer(orderNo, itemNo)
    });;
})


function loadConditionalAcceptanceModal(rowId, orderNo, itemNo) {
    _rowId = rowId;
    _orderNo = orderNo;
    _itemNo = itemNo;
    $("#divConditionalAcceptanceModal").modal("show");
    $('#conditionalAcceptanceError').hide();
    $('#txtProposedFee').val('');
    $('#datetimepickerProposedDueDate').datetimepicker({
        format: 'MM/DD/YYYY'
    });
    $('#txtEditProposedDueDate').val('');
    $('#txtConditionalAcceptanceExplanation').val('');
}

function saveAcceptanceConditionsClick() {
    //at least one of the field need to be fill in
    if (isNullOrWhiteSpace($('#txtConditionalAcceptanceExplanation').val()) && isNullOrWhiteSpace($('#txtProposedFee').val()) && isNullOrWhiteSpace($('#txtEditProposedDueDate').val()) ) {
        $('#conditionalAcceptanceError').show();
    }
    else {
        conditionalAcceptanceProcessRequest($("#" + $$("hdnVendorId_Master").attr("id")).val())
        $("#divConditionalAcceptanceModal").modal("hide");
    }
}

function conditionalAcceptanceProcessRequest(vendorId) {
    var conditionalAcceptance = {
        OrderNo: _orderNo,
        ItemNo: _itemNo,
        VendorId: vendorId,
        ProposedFee: $('#txtProposedFee').val(),
        ProposedDueDate: isNullOrWhiteSpace($('#txtEditProposedDueDate').val()) ? $('#txtEditProposedDueDate').val() : $('#txtEditProposedDueDate').val() + ' 11:59 PM',//requirement to allow user to select only a date, but save it in the DB 11:59pm or 23:59 - do not add if date was left blank
        Explanation: $('#txtConditionalAcceptanceExplanation').val(),
        VA_RowId: _rowId
    }
    var jsonText = $.toJSON({
        conditionalAcceptanceBO: conditionalAcceptance,
        transactionId: $("#" + window.dm_TransactionId).val()
    });
    ajaxSubmit("../../WebServices/DataAccessServiceJson.asmx/ConditionalAcceptanceProcessRequest",
        jsonText,
        function (msg) {
            msg = $.parseJSON(msg.d);
            $("#" + window.dm_TransactionId).val(msg.TransactionId);
            if (msg.Success !== true) {
                ShowError(msg.ErrorMessage);
                return '';
            }

            notifyUser()

            return true;
        });
}

function notifyUser() {
    var okBtn = "<button id='btnOkConditinalAcceptanceAlert' type='button' class='btn btn-primary btn-flat pull-right' causesvalidation='False' style='text-align: center; width: 100px;' onclick='closeConditionalAcceptanceAlertModal()'><i class='fa fa-check'></i>&nbsp;<span>OK</span></button>";
    var data = {
        title: "<span class='bold'>Conditional Acceptance</span>",
        showCloseBtn: true,
        preventBackgroundScrolling: true,
        //headerColor: "#176BAC",
        showCloseBtnFn: "closeConditionalAcceptanceAlertModal()",
        body: String.format("<p>Order {0} is added to your Pending Conditional Acceptance queue.</p>", _orderNo),
        footer: okBtn
    };
    showCommonDialog(data);
}

function closeConditionalAcceptanceAlertModal() {
    hideCommonDialog();
    var pagename = $("#" + $$("pagename").attr("id")).val();
    if (typeof pagename != "undefined" && pagename != null) {
        switch (pagename.toLowerCase()) {
            case "vendorservices/appraiserdashboard":
                //Initiated from Appraiser Dashboard
                loadDashboard(true);
                loadOrdersByVendorId();
                loadDashboardBadges();
                break;
            case "vendorservices/workqueues":
                //Initiated from Work Queues
                loadWorkQueueOrders();
                loadOrdersByVendorId();
                loadDashboardBadges();
                break;
            case "orderstatus":
                //Initiated from Order Dashboard Alerts widget
                window.location.reload();
                break;
            default:
                window.location.reload();
        }
    }
}

function AcceptOrderCounterOffer(orderNo, itemNo) {
    $('[data-toggle="tooltip"]').tooltip("hide");
    var jsonText = $.toJSON({
        orderNo: orderNo,
        itemNo: itemNo,
        transactionId: $("#" + window.dm_TransactionId).val()
    });
    ajaxSubmit("../../WebServices/DataAccessServiceJson.asmx/AcceptOrderCounterOffer",
        jsonText,
        function (msg) {
            msg = $.parseJSON(msg.d);
            $("#" + window.dm_TransactionId).val(msg.TransactionId);
            if (msg.Success !== true) {
                ShowError(msg.ErrorMessage);
                return '';
            }

            $("#messageCenterModal").modal('hide');
            window.location.reload();

            return true;
        });
}

function confirmDenyCounterOffer(orderNo, itemNo) {
    var cancelBtn = "<button type='button' class='btn btn-danger btn-flat pull-left bold' style='width: 100px;' onclick='closeConditionalAcceptanceAlertModal();'><i class='fa fa-remove'></i> Cancel</button>";
    var confirmBtn = "<button id='btnDenyCounterOfferConfirm' type='button' class='btn btn-primary btn-flat pull-right' causesvalidation='False' style='text-align: center; width: 120px;' onclick='btnDenyCounterOfferConfirmClick(" + orderNo +", " + itemNo + ")'><i class='fa fa-check'></i>&nbsp;<span>Confirm</span></button>";
    var data = {
        title: "<span class='bold'>Confirm Response</span>",
        showCloseBtn: true,
        preventBackgroundScrolling: true,
        //headerColor: "#176BAC",
        showCloseBtnFn: "closeConditionalAcceptanceAlertModal()",
        body: String.format("<p>Please confirm you would like to deny this vendor's requested Conditional Acceptance.</p>"),
        footer: cancelBtn + confirmBtn
    };
    showCommonDialog(data);
}

function btnDenyCounterOfferConfirmClick(orderNo, itemNo) {
    var jsonText = $.toJSON({
        orderNo: orderNo,
        itemNo: itemNo,
        transactionId: $("#" + window.dm_TransactionId).val()
    });
    ajaxSubmit("../../WebServices/DataAccessServiceJson.asmx/RejectOrderCounterOffer",
        jsonText,
        function (msg) {
            msg = $.parseJSON(msg.d);
            $("#" + window.dm_TransactionId).val(msg.TransactionId);
            if (msg.Success !== true) {
                ShowError(msg.Result);
                return '';
            }
            closeConditionalAcceptanceAlertModal()
            $("#messageCenterModal").modal('hide');

            window.location.reload();

            return true;

        });
}